<?php
/**
 * ═══════════════════════════════════════════════════════════════
 *  LedgerPro — Professional Accounting Platform
 *  header.php — Shared Page Header & Navigation
 * ═══════════════════════════════════════════════════════════════
 *
 *  Include at the top of every page AFTER config.php and db.php:
 *    require_once 'config.php';
 *    require_once 'db.php';
 *    $page_title = 'Dashboard';
 *    require_once 'header.php';
 *
 *  Expected variables:
 *    $page_title  (string)  — Tab / heading title
 *    $body_class  (string)  — Optional extra class on <body>
 */

if (!isset($page_title)) {
    $page_title = APP_NAME;
}
$body_class = $body_class ?? '';

/* Start session if not already started */
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
    <meta name="description" content="LedgerPro — Professional Accounting Platform">
    <title><?php echo h($page_title) . ' — ' . APP_NAME; ?></title>

    <!-- ── Bootstrap 5.3 CSS ──────────────────────────────────── -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
          rel="stylesheet"
          integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YcnS/1lM6pRhGFi7gWzm0NjBgL1E9Rm0isG"
          crossorigin="anonymous">

    <!-- ── Bootstrap Icons ────────────────────────────────────── -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css"
          rel="stylesheet">

    <!-- ── Google Fonts: DM Sans + Instrument Serif ───────────── -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,300..700;1,9..40,300..700&family=Instrument+Serif:ital@0;1&display=swap"
          rel="stylesheet">

    <!-- ── Custom Application Styles ──────────────────────────── -->
    <style>
        /* ── CSS Variables ─────────────────────────────────────── */
        :root {
            --lp-font-body:    'DM Sans', system-ui, sans-serif;
            --lp-font-display: 'Instrument Serif', Georgia, serif;
            --lp-navy:         #0f172a;
            --lp-navy-light:   #1e293b;
            --lp-slate:        #334155;
            --lp-slate-mid:    #64748b;
            --lp-slate-light:  #94a3b8;
            --lp-silver:       #e2e8f0;
            --lp-snow:         #f8fafc;
            --lp-white:        #ffffff;
            --lp-emerald:      #059669;
            --lp-emerald-soft: #d1fae5;
            --lp-amber:        #d97706;
            --lp-amber-soft:   #fef3c7;
            --lp-red:          #dc2626;
            --lp-red-soft:     #fee2e2;
            --lp-blue:         #2563eb;
            --lp-blue-soft:    #dbeafe;
            --lp-purple:       #7c3aed;
            --lp-purple-soft:  #ede9fe;
            --lp-radius:       0.625rem;
            --lp-radius-lg:    1rem;
            --lp-shadow-sm:    0 1px 2px rgba(15,23,42,.06);
            --lp-shadow:       0 1px 3px rgba(15,23,42,.08), 0 1px 2px rgba(15,23,42,.04);
            --lp-shadow-md:    0 4px 6px -1px rgba(15,23,42,.08), 0 2px 4px -2px rgba(15,23,42,.04);
            --lp-shadow-lg:    0 10px 15px -3px rgba(15,23,42,.08), 0 4px 6px -4px rgba(15,23,42,.04);
            --lp-transition:   all .2s cubic-bezier(.4,0,.2,1);
        }

        /* ── Base ──────────────────────────────────────────────── */
        *, *::before, *::after { box-sizing: border-box; }

        body {
            font-family: var(--lp-font-body);
            font-weight: 400;
            color: var(--lp-slate);
            background: var(--lp-snow);
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        h1, h2, h3, h4, .display-heading {
            font-family: var(--lp-font-display);
            color: var(--lp-navy);
            font-weight: 400;
        }

        /* ── Navbar ────────────────────────────────────────────── */
        .lp-navbar {
            background: var(--lp-white);
            border-bottom: 1px solid var(--lp-silver);
            box-shadow: var(--lp-shadow-sm);
            padding: .65rem 0;
        }
        .lp-navbar .navbar-brand {
            font-family: var(--lp-font-display);
            font-size: 1.45rem;
            color: var(--lp-navy);
            letter-spacing: -.01em;
            display: flex;
            align-items: center;
            gap: .55rem;
        }
        .lp-navbar .navbar-brand .brand-icon {
            width: 34px; height: 34px;
            background: var(--lp-navy);
            border-radius: var(--lp-radius);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: var(--lp-white);
            font-size: 1rem;
        }
        .lp-navbar .nav-link {
            font-size: .875rem;
            font-weight: 500;
            color: var(--lp-slate-mid);
            padding: .45rem .85rem;
            border-radius: var(--lp-radius);
            transition: var(--lp-transition);
        }
        .lp-navbar .nav-link:hover,
        .lp-navbar .nav-link.active {
            color: var(--lp-navy);
            background: var(--lp-snow);
        }
        .lp-navbar .nav-link i {
            font-size: 1.05rem;
            vertical-align: -1px;
            margin-right: .3rem;
        }

        /* ── User Dropdown ─────────────────────────────────────── */
        .lp-user-btn {
            display: flex;
            align-items: center;
            gap: .55rem;
            background: var(--lp-snow);
            border: 1px solid var(--lp-silver);
            border-radius: 50rem;
            padding: .3rem .85rem .3rem .35rem;
            font-size: .8rem;
            font-weight: 500;
            color: var(--lp-navy);
            transition: var(--lp-transition);
            cursor: pointer;
        }
        .lp-user-btn:hover { border-color: var(--lp-slate-light); }
        .lp-user-avatar {
            width: 30px; height: 30px;
            border-radius: 50%;
            background: var(--lp-navy);
            color: var(--lp-white);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: .75rem;
            font-weight: 600;
        }
        .lp-role-badge {
            font-size: .65rem;
            text-transform: uppercase;
            letter-spacing: .06em;
            padding: .15rem .45rem;
            border-radius: 50rem;
            font-weight: 600;
        }
        .lp-role-badge.accountant { background: var(--lp-purple-soft); color: var(--lp-purple); }
        .lp-role-badge.client     { background: var(--lp-blue-soft);   color: var(--lp-blue);   }

        /* ── Page Wrapper ──────────────────────────────────────── */
        .lp-page { padding: 1.75rem 0 3rem; }
        .lp-page-header {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            gap: 1rem;
            margin-bottom: 1.75rem;
        }
        .lp-page-header h1 {
            font-size: 1.75rem;
            margin: 0;
        }
        .lp-page-header .lp-subtitle {
            font-size: .875rem;
            color: var(--lp-slate-mid);
            margin-top: .15rem;
        }

        /* ── Cards ─────────────────────────────────────────────── */
        .lp-card {
            background: var(--lp-white);
            border: 1px solid var(--lp-silver);
            border-radius: var(--lp-radius-lg);
            box-shadow: var(--lp-shadow);
            transition: var(--lp-transition);
        }
        .lp-card:hover { box-shadow: var(--lp-shadow-md); }
        .lp-card .card-body { padding: 1.35rem; }
        .lp-card .card-header {
            background: transparent;
            border-bottom: 1px solid var(--lp-silver);
            padding: 1rem 1.35rem;
            font-weight: 600;
            font-size: .925rem;
            color: var(--lp-navy);
        }

        /* ── Stat Cards ────────────────────────────────────────── */
        .lp-stat {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            padding: 1.25rem;
        }
        .lp-stat-icon {
            width: 46px; height: 46px;
            border-radius: var(--lp-radius);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            flex-shrink: 0;
        }
        .lp-stat-icon.emerald { background: var(--lp-emerald-soft); color: var(--lp-emerald); }
        .lp-stat-icon.amber   { background: var(--lp-amber-soft);   color: var(--lp-amber);   }
        .lp-stat-icon.red     { background: var(--lp-red-soft);     color: var(--lp-red);     }
        .lp-stat-icon.blue    { background: var(--lp-blue-soft);    color: var(--lp-blue);    }
        .lp-stat-icon.purple  { background: var(--lp-purple-soft);  color: var(--lp-purple);  }
        .lp-stat-label {
            font-size: .775rem;
            text-transform: uppercase;
            letter-spacing: .05em;
            color: var(--lp-slate-mid);
            font-weight: 600;
            margin-bottom: .2rem;
        }
        .lp-stat-value {
            font-family: var(--lp-font-display);
            font-size: 1.55rem;
            color: var(--lp-navy);
            line-height: 1.2;
        }

        /* ── Tables ────────────────────────────────────────────── */
        .lp-table {
            width: 100%;
            font-size: .855rem;
        }
        .lp-table thead th {
            background: var(--lp-snow);
            font-weight: 600;
            font-size: .75rem;
            text-transform: uppercase;
            letter-spacing: .05em;
            color: var(--lp-slate-mid);
            padding: .75rem 1rem;
            border-bottom: 2px solid var(--lp-silver);
            white-space: nowrap;
        }
        .lp-table tbody td {
            padding: .8rem 1rem;
            border-bottom: 1px solid #f1f5f9;
            vertical-align: middle;
            color: var(--lp-slate);
        }
        .lp-table tbody tr:hover { background: var(--lp-snow); }
        .lp-table tbody tr:last-child td { border-bottom: none; }

        /* ── Status Badges ─────────────────────────────────────── */
        .lp-badge {
            display: inline-flex;
            align-items: center;
            gap: .3rem;
            font-size: .72rem;
            font-weight: 600;
            padding: .25rem .6rem;
            border-radius: 50rem;
            text-transform: uppercase;
            letter-spacing: .04em;
        }
        .lp-badge.draft     { background: var(--lp-silver);       color: var(--lp-slate);   }
        .lp-badge.sent      { background: var(--lp-blue-soft);    color: var(--lp-blue);    }
        .lp-badge.paid      { background: var(--lp-emerald-soft); color: var(--lp-emerald); }
        .lp-badge.overdue   { background: var(--lp-red-soft);     color: var(--lp-red);     }
        .lp-badge.cancelled { background: #f1f5f9;                color: var(--lp-slate-light); }
        .lp-badge::before {
            content: '';
            width: 6px; height: 6px;
            border-radius: 50%;
            background: currentColor;
        }

        /* ── Buttons ───────────────────────────────────────────── */
        .btn-lp-primary {
            background: var(--lp-navy);
            color: var(--lp-white);
            border: none;
            border-radius: var(--lp-radius);
            font-weight: 500;
            font-size: .855rem;
            padding: .5rem 1.15rem;
            transition: var(--lp-transition);
        }
        .btn-lp-primary:hover {
            background: var(--lp-navy-light);
            color: var(--lp-white);
            transform: translateY(-1px);
            box-shadow: var(--lp-shadow-md);
        }
        .btn-lp-outline {
            background: var(--lp-white);
            color: var(--lp-slate);
            border: 1px solid var(--lp-silver);
            border-radius: var(--lp-radius);
            font-weight: 500;
            font-size: .855rem;
            padding: .5rem 1.15rem;
            transition: var(--lp-transition);
        }
        .btn-lp-outline:hover {
            border-color: var(--lp-slate-light);
            color: var(--lp-navy);
            background: var(--lp-snow);
        }
        .btn-lp-danger {
            background: var(--lp-red);
            color: var(--lp-white);
            border: none;
            border-radius: var(--lp-radius);
            font-weight: 500;
            font-size: .855rem;
            padding: .5rem 1.15rem;
            transition: var(--lp-transition);
        }
        .btn-lp-danger:hover {
            background: #b91c1c;
            color: var(--lp-white);
        }

        /* ── Forms ─────────────────────────────────────────────── */
        .lp-form .form-label {
            font-size: .8rem;
            font-weight: 600;
            color: var(--lp-navy);
            margin-bottom: .35rem;
        }
        .lp-form .form-control,
        .lp-form .form-select {
            border-radius: var(--lp-radius);
            border: 1px solid var(--lp-silver);
            font-size: .875rem;
            padding: .55rem .85rem;
            transition: var(--lp-transition);
        }
        .lp-form .form-control:focus,
        .lp-form .form-select:focus {
            border-color: var(--lp-navy);
            box-shadow: 0 0 0 3px rgba(15,23,42,.08);
        }

        /* ── Flash Messages ────────────────────────────────────── */
        .lp-flash {
            border-radius: var(--lp-radius);
            padding: .85rem 1.15rem;
            font-size: .855rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: .55rem;
            margin-bottom: 1.25rem;
            animation: lpSlideIn .3s ease-out;
        }
        .lp-flash.success { background: var(--lp-emerald-soft); color: var(--lp-emerald); border: 1px solid #a7f3d0; }
        .lp-flash.error   { background: var(--lp-red-soft);     color: var(--lp-red);     border: 1px solid #fecaca; }
        .lp-flash.warning { background: var(--lp-amber-soft);   color: var(--lp-amber);   border: 1px solid #fde68a; }
        .lp-flash.info    { background: var(--lp-blue-soft);    color: var(--lp-blue);    border: 1px solid #bfdbfe; }

        @keyframes lpSlideIn {
            from { opacity: 0; transform: translateY(-.5rem); }
            to   { opacity: 1; transform: translateY(0); }
        }

        /* ── Pagination ────────────────────────────────────────── */
        .lp-pagination .page-link {
            font-size: .8rem;
            color: var(--lp-slate);
            border-color: var(--lp-silver);
            border-radius: var(--lp-radius) !important;
            margin: 0 .15rem;
            padding: .35rem .7rem;
        }
        .lp-pagination .page-item.active .page-link {
            background: var(--lp-navy);
            border-color: var(--lp-navy);
            color: var(--lp-white);
        }

        /* ── Empty State ───────────────────────────────────────── */
        .lp-empty {
            text-align: center;
            padding: 3rem 1rem;
            color: var(--lp-slate-mid);
        }
        .lp-empty i {
            font-size: 2.5rem;
            margin-bottom: .75rem;
            opacity: .4;
        }
        .lp-empty p {
            font-size: .9rem;
            margin: 0;
        }

        /* ── Responsive Helpers ────────────────────────────────── */
        .lp-table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        @media (max-width: 768px) {
            .lp-page-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .lp-page-header h1 { font-size: 1.4rem; }
            .lp-stat-value { font-size: 1.3rem; }
            .lp-navbar .navbar-brand { font-size: 1.25rem; }
            .lp-navbar .navbar-brand .brand-icon { width: 30px; height: 30px; font-size: .85rem; }
            .lp-hide-mobile { display: none !important; }
        }

        @media (max-width: 576px) {
            .lp-page { padding: 1.25rem 0 2rem; }
            .lp-card .card-body { padding: 1rem; }
        }
    </style>
</head>
<body class="<?php echo h($body_class); ?>">

<!-- ═══ Top Navigation Bar ══════════════════════════════════════ -->
<?php if (is_logged_in()): ?>
<nav class="navbar navbar-expand-lg lp-navbar sticky-top">
    <div class="container">
        <!-- Brand -->
        <a class="navbar-brand" href="<?php echo APP_URL; ?>/dashboard.php">
            <span class="brand-icon"><i class="bi bi-journal-bookmark-fill"></i></span>
            <?php echo APP_NAME; ?>
        </a>

        <!-- Mobile toggle -->
        <button class="navbar-toggler border-0 shadow-none" type="button"
                data-bs-toggle="collapse" data-bs-target="#lpMainNav"
                aria-controls="lpMainNav" aria-expanded="false" aria-label="Toggle navigation">
            <i class="bi bi-list fs-4" style="color:var(--lp-navy)"></i>
        </button>

        <!-- Collapsible menu -->
        <div class="collapse navbar-collapse" id="lpMainNav">
            <ul class="navbar-nav me-auto ms-lg-4 gap-1 mt-2 mt-lg-0">

                <!-- Dashboard — both roles -->
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'dashboard.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/dashboard.php">
                        <i class="bi bi-grid-1x2"></i> Dashboard
                    </a>
                </li>

                <?php if (is_accountant()): ?>
                <!-- ── Accountant-only links ────────────────────── -->
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'clients.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/clients.php">
                        <i class="bi bi-people"></i> Clients
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'invoices.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/invoices.php">
                        <i class="bi bi-receipt"></i> Invoices
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'payments.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/payments.php">
                        <i class="bi bi-credit-card"></i> Payments
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'income.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/income.php">
                        <i class="bi bi-graph-up-arrow"></i> Income
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'expenses.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/expenses.php">
                        <i class="bi bi-wallet2"></i> Expenses
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'reports.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/reports.php">
                        <i class="bi bi-bar-chart-line"></i> Reports
                    </a>
                </li>

                <?php else: ?>
                <!-- ── Client-only links ────────────────────────── -->
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'invoices.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/invoices.php">
                        <i class="bi bi-receipt"></i> My Invoices
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['SCRIPT_NAME']) === 'payments.php' ? 'active' : ''; ?>"
                       href="<?php echo APP_URL; ?>/payments.php">
                        <i class="bi bi-credit-card"></i> My Payments
                    </a>
                </li>
                <?php endif; ?>
            </ul>

            <!-- Right side: user menu -->
            <div class="dropdown mt-2 mt-lg-0">
                <button class="lp-user-btn dropdown-toggle" type="button"
                        data-bs-toggle="dropdown" aria-expanded="false">
                    <span class="lp-user-avatar">
                        <?php echo strtoupper(mb_substr($_SESSION['user_name'] ?? 'U', 0, 1)); ?>
                    </span>
                    <span class="lp-hide-mobile">
                        <?php echo h($_SESSION['user_name'] ?? 'User'); ?>
                    </span>
                    <span class="lp-role-badge <?php echo h($_SESSION['user_role'] ?? ''); ?>">
                        <?php echo h(ucfirst($_SESSION['user_role'] ?? '')); ?>
                    </span>
                </button>
                <ul class="dropdown-menu dropdown-menu-end shadow-sm border" style="min-width:200px">
                    <li class="px-3 py-2 border-bottom">
                        <small class="text-muted d-block" style="font-size:.72rem">Signed in as</small>
                        <span class="fw-semibold" style="font-size:.85rem">
                            <?php echo h($_SESSION['user_email'] ?? ''); ?>
                        </span>
                    </li>
                    <li>
                        <a class="dropdown-item py-2" href="<?php echo APP_URL; ?>/profile.php">
                            <i class="bi bi-person me-2"></i> Profile
                        </a>
                    </li>
                    <?php if (is_accountant()): ?>
                    <li>
                        <a class="dropdown-item py-2" href="<?php echo APP_URL; ?>/users.php">
                            <i class="bi bi-shield-lock me-2"></i> Manage Users
                        </a>
                    </li>
                    <?php endif; ?>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <a class="dropdown-item py-2 text-danger" href="<?php echo APP_URL; ?>/logout.php">
                            <i class="bi bi-box-arrow-right me-2"></i> Sign Out
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php endif; ?>

<!-- ═══ Flash Messages ══════════════════════════════════════════ -->
<div class="container lp-page">
<?php
$flash_types = ['success', 'error', 'warning', 'info'];
foreach ($flash_types as $ft):
    $msg = flash($ft);
    if ($msg):
        $icon = match($ft) {
            'success' => 'bi-check-circle-fill',
            'error'   => 'bi-exclamation-triangle-fill',
            'warning' => 'bi-exclamation-circle-fill',
            'info'    => 'bi-info-circle-fill',
        };
?>
    <div class="lp-flash <?php echo $ft; ?>">
        <i class="bi <?php echo $icon; ?>"></i>
        <?php echo h($msg); ?>
    </div>
<?php
    endif;
endforeach;
?>
